/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import net.algart.drawing3d.CoordinateSystem3D;
import net.algart.drawing3d.DrawingRule;
import net.algart.drawing3d.Orientation3D;
import net.algart.drawing3d.Pixel3DDrawer;
import net.algart.drawing3d.PlanePolygon3D;
import net.algart.drawing3d.Shape3D;

public class ConvexPlanePolygon3DDrawingRule
implements DrawingRule {
    public boolean isApplicable(Shape3D shape3D, Object object) {
        return shape3D instanceof PlanePolygon3D;
    }

    public void draw(Shape3D shape3D, Pixel3DDrawer pixel3DDrawer, CoordinateSystem3D coordinateSystem3D, Rectangle2D rectangle2D, double d, Color color) {
        if (shape3D == null) {
            throw new NullPointerException("Null shape argument");
        }
        if (pixel3DDrawer == null) {
            throw new NullPointerException("Null pixelDrawer argument");
        }
        if (coordinateSystem3D == null) {
            throw new NullPointerException("Null coordinateSystemOfModel argument");
        }
        if (rectangle2D == null) {
            throw new NullPointerException("Null screenArea argument");
        }
        if (color == null) {
            throw new NullPointerException("Null color argument");
        }
        PlanePolygon3D planePolygon3D = (PlanePolygon3D)shape3D;
        int n = planePolygon3D.getVerticesCount();
        if (n < 3) {
            return;
        }
        double[] dArray = planePolygon3D.getVerticesXYZ();
        assert (dArray.length == 3 * n);
        ConvexPlanePolygon3DDrawingRule.transform(dArray, coordinateSystem3D);
        double[] dArray2 = new double[]{dArray[0], dArray[0], dArray[1], dArray[1], dArray[2], dArray[2]};
        for (int i = 3; i < dArray.length; i += 3) {
            dArray2[0] = Math.min(dArray2[0], dArray[i]);
            dArray2[1] = Math.max(dArray2[1], dArray[i]);
            dArray2[2] = Math.min(dArray2[2], dArray[i + 1]);
            dArray2[3] = Math.max(dArray2[3], dArray[i + 1]);
            dArray2[4] = Math.min(dArray2[4], dArray[i + 2]);
            dArray2[5] = Math.max(dArray2[5], dArray[i + 2]);
        }
        if (dArray2[4] >= d) {
            return;
        }
        double d2 = rectangle2D.getMinX();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMinY();
        double d5 = rectangle2D.getMaxY();
        if (dArray2[1] < d2 || dArray2[0] > d3 || dArray2[3] < d4 || dArray2[2] > d5) {
            return;
        }
        double d6 = planePolygon3D.getA();
        double d7 = planePolygon3D.getB();
        double d8 = planePolygon3D.getC();
        Orientation3D orientation3D = coordinateSystem3D.getOrientation();
        double d9 = coordinateSystem3D.getOriginX();
        double d10 = coordinateSystem3D.getOriginY();
        double d11 = coordinateSystem3D.getOriginZ();
        double d12 = orientation3D.transformX(d6, d7, d8);
        double d13 = orientation3D.transformY(d6, d7, d8);
        double d14 = orientation3D.transformZ(d6, d7, d8);
        double d15 = planePolygon3D.getD() * coordinateSystem3D.getScale() + d6 * orientation3D.inverseTransformX(d9, d10, d11) + d7 * orientation3D.inverseTransformY(d9, d10, d11) + d8 * orientation3D.inverseTransformZ(d9, d10, d11);
        if (d14 == 0.0) {
            return;
        }
        double d16 = 1.0 / d14;
        double d17 = Math.sqrt(d12 * d12 + d13 * d13 + d14 * d14);
        double d18 = d12 / d17;
        double d19 = d13 / d17;
        double d20 = d14 / d17;
        int n2 = (int)Math.floor(Math.max(dArray2[0], d2));
        int n3 = (int)Math.ceil(Math.min(dArray2[1], d3));
        int n4 = (int)Math.floor(Math.max(dArray2[2], d4));
        int n5 = (int)Math.ceil(Math.min(dArray2[3], d5));
        for (int i = n4; i <= n5; ++i) {
            double d21;
            int n6;
            int n7 = Integer.MAX_VALUE;
            int n8 = Integer.MIN_VALUE;
            for (n6 = 0; n6 < dArray.length; n6 += 3) {
                double d22;
                d21 = dArray[n6];
                double d23 = dArray[n6 + 1];
                double d24 = n6 + 3 == dArray.length ? dArray[0] : dArray[n6 + 3];
                double d25 = d22 = n6 + 3 == dArray.length ? dArray[1] : dArray[n6 + 4];
                if (d23 == d22 || !(Math.min(d23, d22) <= (double)i) || !(Math.max(d23, d22) >= (double)i)) continue;
                int n9 = (int)Math.floor(d21 + (d24 - d21) * ((double)i - d23) / (d22 - d23) + 0.5);
                n7 = Math.min(n7, n9);
                n8 = Math.max(n8, n9);
            }
            n7 = Math.max(n2, n7);
            n8 = Math.min(n3, n8);
            for (n6 = n7; n6 <= n8; ++n6) {
                d21 = (d15 - d12 * (double)n6 - d13 * (double)i) * d16;
                pixel3DDrawer.drawPoint(n6, i, d21, d18, d19, d20, color);
            }
        }
    }

    public void estimateContainingParallelepiped(double[] dArray, Shape3D shape3D, CoordinateSystem3D coordinateSystem3D) {
        if (dArray == null) {
            throw new NullPointerException("Null result argument");
        }
        if (shape3D == null) {
            throw new NullPointerException("Null shape argument");
        }
        if (coordinateSystem3D == null) {
            throw new NullPointerException("Null coordinateSystemOfModel argument");
        }
        PlanePolygon3D planePolygon3D = (PlanePolygon3D)shape3D;
        int n = planePolygon3D.getVerticesCount();
        if (n < 3) {
            return;
        }
        double[] dArray2 = planePolygon3D.getVerticesXYZ();
        assert (dArray2.length == 3 * n);
        ConvexPlanePolygon3DDrawingRule.transform(dArray2, coordinateSystem3D);
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[0];
        dArray[2] = dArray2[1];
        dArray[3] = dArray2[1];
        dArray[4] = dArray2[2];
        dArray[5] = dArray2[2];
        for (int i = 3; i < dArray2.length; i += 3) {
            dArray[0] = Math.min(dArray[0], dArray2[i]);
            dArray[1] = Math.max(dArray[1], dArray2[i]);
            dArray[2] = Math.min(dArray[2], dArray2[i + 1]);
            dArray[3] = Math.max(dArray[3], dArray2[i + 1]);
            dArray[4] = Math.min(dArray[4], dArray2[i + 2]);
            dArray[5] = Math.max(dArray[5], dArray2[i + 2]);
        }
    }

    private static void transform(double[] dArray, CoordinateSystem3D coordinateSystem3D) {
        for (int i = 0; i < dArray.length; i += 3) {
            double d = coordinateSystem3D.transformX(dArray[i], dArray[i + 1], dArray[i + 2]);
            double d2 = coordinateSystem3D.transformY(dArray[i], dArray[i + 1], dArray[i + 2]);
            double d3 = coordinateSystem3D.transformZ(dArray[i], dArray[i + 1], dArray[i + 2]);
            dArray[i] = d;
            dArray[i + 1] = d2;
            dArray[i + 2] = d3;
        }
    }
}

