/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

import net.algart.drawing3d.Shape3D;

public class PlanePolygon3D
implements Shape3D {
    private final double a;
    private final double b;
    private final double c;
    private final double d;
    private final int verticesCount;
    private final double[] verticesXYZ;

    public PlanePolygon3D(double d, double d2, double d3, double d4, double ... dArray) {
        if (dArray.length % 3 != 0) {
            throw new IllegalArgumentException("verticesXYZ must contain 3*N elements: verticesXYZ[3*k] is X, verticesXYZ[3*k+1] is Y, verticesXYZ[3*k+2] is Z");
        }
        if (dArray.length < 9) {
            throw new IllegalArgumentException("verticesXYZ must contain at least 9 elements (3 vertices)");
        }
        double d5 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d5 == 0.0) {
            throw new IllegalArgumentException("The norm of (a,b,c) vector is zero");
        }
        this.a = d / d5;
        this.b = d2 / d5;
        this.c = d3 / d5;
        this.d = d4 / d5;
        this.verticesXYZ = (double[])dArray.clone();
        this.verticesCount = dArray.length / 3;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    public double getD() {
        return this.d;
    }

    public int getVerticesCount() {
        return this.verticesCount;
    }

    public double[] getVerticesXYZ() {
        return (double[])this.verticesXYZ.clone();
    }

    public String toString() {
        return "3D polygon with " + this.verticesCount + " vertices at the plane " + this.a + "*x + " + this.b + "*y + " + this.c + "*z = " + this.d;
    }
}

