/*
 * Decompiled with CFR 0.152.
 */
package net.algart.drawing3d;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.List;
import net.algart.drawing3d.ColoringRule;
import net.algart.drawing3d.Drawer3D;
import net.algart.drawing3d.DrawingRule;
import net.algart.drawing3d.ShapingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDrawer3D
extends Drawer3D {
    public static final int MAX_ANTIALIASING_SCALE = 2048;
    private final int imageWidth;
    private final int imageHeight;
    private final int antialiasingScale;
    private final byte[] red;
    private final byte[] green;
    private final byte[] blue;
    private float[] zBuffer;
    private final int[] pixels;

    private SimpleDrawer3D(int n, int n2, int n3, Color color, List<ShapingRule> list, List<ColoringRule> list2, List<DrawingRule> list3) {
        super(SimpleDrawer3D.product32(n, n3, "imageWidth * antialiasingScale"), SimpleDrawer3D.product32(n2, n3, "imageHeight * antialiasingScale"), color, list, list2, list3);
        if (n3 <= 0) {
            throw new IllegalArgumentException("antialiasingScale must be positive");
        }
        if (n3 > 2048) {
            throw new IllegalArgumentException("antialiasingScale cannot be >2048");
        }
        if ((long)this.screenWidth * (long)this.screenWidth > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large screen sizes " + this.screenWidth + "*" + this.screenHeight);
        }
        int n4 = this.screenWidth * this.screenHeight;
        this.imageWidth = n;
        this.imageHeight = n2;
        this.antialiasingScale = n3;
        this.red = new byte[n4];
        this.green = new byte[n4];
        this.blue = new byte[n4];
        this.zBuffer = new float[n4];
        this.pixels = new int[n * n2];
        this.clearRect(0, 0, this.screenWidth, this.screenHeight);
    }

    public static SimpleDrawer3D getSimpleDrawer3D(int n, int n2, int n3, Color color, List<ShapingRule> list, List<ColoringRule> list2, List<DrawingRule> list3) {
        return new SimpleDrawer3D(n, n2, n3, color, list, list2, list3);
    }

    public int getAntialiasingScale() {
        return this.antialiasingScale;
    }

    @Override
    public int getImageWidth() {
        return this.imageWidth;
    }

    @Override
    public int getImageHeight() {
        return this.imageHeight;
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (n3 <= 0 || n4 <= 0 || n >= this.screenWidth || n2 >= this.screenHeight || n5 <= 0 || n6 <= 0) {
            return;
        }
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        n5 = Math.min(n5, this.screenWidth);
        n6 = Math.min(n6, this.screenHeight);
        Color color = this.getBackgroundColor();
        byte by = (byte)color.getRed();
        byte by2 = (byte)color.getGreen();
        byte by3 = (byte)color.getBlue();
        for (int i = n2; i < n6; ++i) {
            int n7 = n;
            int n8 = i * this.screenWidth + n7;
            while (n7 < n5) {
                this.red[n8] = by;
                this.green[n8] = by2;
                this.blue[n8] = by3;
                this.zBuffer[n8] = Float.NEGATIVE_INFINITY;
                ++n7;
                ++n8;
            }
        }
    }

    @Override
    public void drawPoint(int n, int n2, double d, double d2, double d3, double d4, Color color) {
        int n3 = color.getAlpha();
        if (n3 == 0) {
            return;
        }
        int n4 = (int)(Math.abs(d4) * 256.0);
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 > 256) {
            n4 = 256;
        }
        if (n < 0 || n2 < 0 || n >= this.screenWidth || n2 >= this.screenHeight) {
            return;
        }
        int n5 = n2 * this.screenWidth + n;
        if (d > this.zCut || d < (double)this.zBuffer[n5]) {
            return;
        }
        n4 = this.gammaCorrection(n4);
        int n6 = color.getRed();
        int n7 = color.getGreen();
        int n8 = color.getBlue();
        if (n3 == 255) {
            this.red[n5] = (byte)(n6 * n4 >> 8);
            this.green[n5] = (byte)(n7 * n4 >> 8);
            this.blue[n5] = (byte)(n8 * n4 >> 8);
        } else {
            n6 = ((this.red[n5] & 0xFF) * (255 - n3) + (n6 * n4 >> 8) * n3) / 255;
            n7 = ((this.green[n5] & 0xFF) * (255 - n3) + (n7 * n4 >> 8) * n3) / 255;
            n8 = ((this.blue[n5] & 0xFF) * (255 - n3) + (n8 * n4 >> 8) * n3) / 255;
            assert (n6 >= 0 && n6 <= 256);
            assert (n7 >= 0 && n7 <= 256);
            assert (n8 >= 0 && n8 <= 256);
            this.red[n5] = (byte)n6;
            this.green[n5] = (byte)n7;
            this.blue[n5] = (byte)n8;
        }
        this.zBuffer[n5] = (float)d;
    }

    @Override
    public BufferedImage getImage() {
        int n;
        int n2;
        long l = System.nanoTime();
        if (this.antialiasingScale == 1) {
            int n3 = 0;
            for (int i = 0; i < this.imageHeight; ++i) {
                n2 = 0;
                while (n2 < this.imageWidth) {
                    int n4 = this.red[n3] & 0xFF;
                    int n5 = this.green[n3] & 0xFF;
                    n = this.blue[n3] & 0xFF;
                    assert (n4 < 256 && n5 < 256 && n < 256);
                    this.pixels[n3] = n4 << 16 | n5 << 8 | n;
                    ++n2;
                    ++n3;
                }
            }
        } else if ((this.antialiasingScale & this.antialiasingScale - 1) == 0) {
            int n6 = 31 - Integer.numberOfLeadingZeros(this.antialiasingScale * this.antialiasingScale);
            int n7 = this.antialiasingScale * this.antialiasingScale >> 1;
            int n8 = 0;
            for (n2 = 0; n2 < this.imageHeight; ++n2) {
                int n9 = 0;
                while (n9 < this.imageWidth) {
                    int n10;
                    n = 0;
                    int n11 = 0;
                    int n12 = 0;
                    int n13 = (n2 * this.screenWidth + n9) * this.antialiasingScale;
                    int n14 = 0;
                    while (n14 < this.antialiasingScale) {
                        for (n10 = 0; n10 < this.antialiasingScale; ++n10) {
                            n += this.red[n13 + n10] & 0xFF;
                            n11 += this.green[n13 + n10] & 0xFF;
                            n12 += this.blue[n13 + n10] & 0xFF;
                        }
                        ++n14;
                        n13 += this.screenWidth;
                    }
                    n14 = n + n7 >> n6;
                    n10 = n11 + n7 >> n6;
                    int n15 = n12 + n7 >> n6;
                    assert (n14 < 256 && n10 < 256 && n15 < 256);
                    this.pixels[n8] = n14 << 16 | n10 << 8 | n15;
                    ++n9;
                    ++n8;
                }
            }
        } else {
            double d = 1.0 / (double)(this.antialiasingScale * this.antialiasingScale);
            int n16 = 0;
            for (n2 = 0; n2 < this.imageHeight; ++n2) {
                int n17 = 0;
                while (n17 < this.imageWidth) {
                    int n18;
                    n = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = (n2 * this.screenWidth + n17) * this.antialiasingScale;
                    int n22 = 0;
                    while (n22 < this.antialiasingScale) {
                        for (n18 = 0; n18 < this.antialiasingScale; ++n18) {
                            n += this.red[n21 + n18] & 0xFF;
                            n19 += this.green[n21 + n18] & 0xFF;
                            n20 += this.blue[n21 + n18] & 0xFF;
                        }
                        ++n22;
                        n21 += this.screenWidth;
                    }
                    n22 = (int)((double)n * d + 0.5);
                    n18 = (int)((double)n19 * d + 0.5);
                    int n23 = (int)((double)n20 * d + 0.5);
                    assert (n22 < 256 && n18 < 256 && n23 < 256);
                    this.pixels[n16] = n22 << 16 | n18 << 8 | n23;
                    ++n17;
                    ++n16;
                }
            }
        }
        long l2 = System.nanoTime();
        WritableRaster writableRaster = Raster.createPackedRaster(new DataBufferInt(this.pixels, this.pixels.length), this.imageWidth, this.imageHeight, this.imageWidth, new int[]{0xFF0000, 65280, 255}, new Point(0, 0));
        long l3 = System.nanoTime();
        BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(24, 0xFF0000, 65280, 255, 0), writableRaster, false, null);
        long l4 = System.nanoTime();
        return bufferedImage;
    }

    private static int product32(int n, int n2, String string) {
        n2 = Math.max(1, n2);
        if ((long)Math.abs(n) * (long)n2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too large product " + string + " = " + n + "*" + n2 + "> Integer.MAX_VALUE by absolute value");
        }
        return n * n2;
    }
}

