/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import net.algart.model3d.common.movement.model.HavingMass;
import net.algart.model3d.common.movement.model.HavingVelocity;
import net.algart.model3d.common.movement.model.InteractionRule;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemSet;
import net.algart.model3d.common.movement.model.MovementIntegrator;
import net.algart.model3d.common.movement.model.SymmetricInteractionRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMovementIntegrator
implements MovementIntegrator {
    private static final int GLOBAL_THREAD_POOL_SIZE = Math.max(2, Runtime.getRuntime().availableProcessors());
    private static final ExecutorService GLOBAL_THREAD_POOL = Executors.newFixedThreadPool(GLOBAL_THREAD_POOL_SIZE);
    final ItemSet itemSet;
    final List<InteractionRule> interactionRules;
    private volatile int numberOfParallelTasks = 1;
    private volatile boolean viscousForces;
    private volatile double accelerationLimit = Double.POSITIVE_INFINITY;
    private volatile double velocityLimit = Double.POSITIVE_INFINITY;
    private volatile double t = 0.0;
    private volatile double deltaT = 0.0;
    private int[][] interactingIndexes = new int[0][0];
    protected final AtomicLong countOfProcessedItems = new AtomicLong(0L);
    protected final AtomicLong countOfCheckedNeighbours = new AtomicLong(0L);
    protected final AtomicLong countOfProcessedInteractions = new AtomicLong(0L);
    protected final AtomicLong countOfProcessedSymmetricInteractions = new AtomicLong(0L);
    protected int n = 0;

    protected AbstractMovementIntegrator(ItemSet itemSet, Collection<InteractionRule> collection, double d) {
        if (itemSet == null) {
            throw new NullPointerException("Null itemSet");
        }
        if (collection == null) {
            throw new NullPointerException("Null interactionRules");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative deltaT");
        }
        this.itemSet = itemSet;
        this.interactionRules = new ArrayList<InteractionRule>();
        for (InteractionRule interactionRule : collection) {
            if (interactionRule == null) {
                throw new NullPointerException("Null element of interactionRules list");
            }
            this.interactionRules.add(interactionRule);
        }
        this.deltaT = d;
    }

    @Override
    public ItemSet getItemSet() {
        return this.itemSet;
    }

    @Override
    public List<InteractionRule> getInteractionRules() {
        return Collections.unmodifiableList(this.interactionRules);
    }

    @Override
    public int getNumberOfParallelTasks() {
        return this.numberOfParallelTasks;
    }

    @Override
    public void setNumberOfParallelTasks(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative numberOfParallelTasks");
        }
        if (n == 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        this.numberOfParallelTasks = n;
    }

    @Override
    public boolean getViscousForces() {
        return this.viscousForces;
    }

    @Override
    public void setViscousForces(boolean bl) {
        this.viscousForces = bl;
    }

    @Override
    public double getAccelerationLimit() {
        return this.accelerationLimit;
    }

    @Override
    public void setAccelerationLimit(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative accelerationLimit");
        }
        this.accelerationLimit = d;
    }

    @Override
    public double getVelocityLimit() {
        return this.velocityLimit;
    }

    @Override
    public void setVelocityLimit(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative velocityLimit");
        }
        this.velocityLimit = d;
    }

    @Override
    public double getT() {
        return this.t;
    }

    @Override
    public void setT(double d) {
        this.t = d;
    }

    @Override
    public double getDeltaT() {
        return this.deltaT;
    }

    @Override
    public void setDeltaT(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative deltaT");
        }
        this.deltaT = d;
    }

    @Override
    public void copyBasicSettings(MovementIntegrator movementIntegrator) {
        this.setNumberOfParallelTasks(movementIntegrator.getNumberOfParallelTasks());
        this.setViscousForces(movementIntegrator.getViscousForces());
        this.setAccelerationLimit(movementIntegrator.getAccelerationLimit());
        this.setVelocityLimit(movementIntegrator.getVelocityLimit());
        this.setT(movementIntegrator.getT());
        this.setDeltaT(movementIntegrator.getDeltaT());
    }

    @Override
    public long getCounterOfProcessedItems() {
        return this.countOfProcessedItems.get();
    }

    @Override
    public long getCounterOfCheckedNeighbours() {
        return this.countOfCheckedNeighbours.get();
    }

    @Override
    public long getCounterOfProcessedInteractions() {
        return this.countOfProcessedInteractions.get();
    }

    @Override
    public long getCounterOfProcessedSymmetricInteractions() {
        return this.countOfProcessedSymmetricInteractions.get();
    }

    @Override
    public void resetCounters() {
        this.countOfProcessedItems.set(0L);
        this.countOfCheckedNeighbours.set(0L);
        this.countOfProcessedInteractions.set(0L);
        this.countOfProcessedSymmetricInteractions.set(0L);
    }

    @Override
    public abstract void performIteration();

    @Override
    public boolean isErrorInformationAvailable() {
        return false;
    }

    @Override
    public double maxLastCoordinateError() {
        return Double.NaN;
    }

    @Override
    public double maxLastVelocityError() {
        return Double.NaN;
    }

    @Override
    public double meanLastCoordinateError() {
        return Double.NaN;
    }

    @Override
    public double meanLastVelocityError() {
        return Double.NaN;
    }

    protected void calculateLeftSide(final double[] dArray, final double[] dArray2, final double[] dArray3, final double[] dArray4, final double[] dArray5, final double[] dArray6, final double d) {
        int n;
        if (dArray == null) {
            throw new NullPointerException("Null resultDX");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Null resultDY");
        }
        if (dArray3 == null) {
            throw new NullPointerException("Null resultDZ");
        }
        if (dArray4 == null) {
            throw new NullPointerException("Null resultDVX");
        }
        if (dArray5 == null) {
            throw new NullPointerException("Null resultDVY");
        }
        if (dArray6 == null) {
            throw new NullPointerException("Null resultDVZ");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative " + d);
        }
        int n2 = this.numberOfParallelTasks;
        if (n2 == 1 || this.n == 1) {
            this.calculateLeftSide(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, d, 0, 0, this.n);
            return;
        }
        Runnable[] runnableArray = new Runnable[n2];
        for (int i = 0; i < runnableArray.length; ++i) {
            n = i;
            final int n3 = (int)((double)n / (double)runnableArray.length * (double)this.n);
            final int n4 = n == runnableArray.length - 1 ? this.n : (int)((double)(n + 1) / (double)runnableArray.length * (double)this.n);
            runnableArray[i] = new Runnable(){

                public void run() {
                    AbstractMovementIntegrator.this.calculateLeftSide(dArray, dArray2, dArray3, dArray4, dArray5, dArray6, d, n, n3, n4);
                }
            };
        }
        Future[] futureArray = new Future[n2];
        for (n = 0; n < runnableArray.length; ++n) {
            futureArray[n] = GLOBAL_THREAD_POOL.submit(runnableArray[n]);
        }
        try {
            for (n = 0; n < runnableArray.length; ++n) {
                futureArray[n].get();
            }
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new AssertionError((Object)("Unexpected checked exception: " + throwable));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    protected void calculateLeftSide(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double d, int n, int n2, int n3) {
        double d2;
        int n4;
        if (dArray == null) {
            throw new NullPointerException("Null resultDX");
        }
        if (dArray2 == null) {
            throw new NullPointerException("Null resultDY");
        }
        if (dArray3 == null) {
            throw new NullPointerException("Null resultDZ");
        }
        if (dArray4 == null) {
            throw new NullPointerException("Null resultDVX");
        }
        if (dArray5 == null) {
            throw new NullPointerException("Null resultDVY");
        }
        if (dArray6 == null) {
            throw new NullPointerException("Null resultDVZ");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Negative " + d);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Illegal fromIndex = " + n2);
        }
        if (n3 > this.n) {
            throw new IndexOutOfBoundsException("Illegal toIndex = " + n3 + " > " + this.n);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("Illegal fromIndex and toIndex: " + n2 + " > " + n3);
        }
        if (n < 0 || n >= this.numberOfParallelTasks) {
            throw new IndexOutOfBoundsException("Illegal threadIndex = " + n + ": not in 0.." + (this.numberOfParallelTasks - 1) + " range");
        }
        double[] dArray7 = new double[3];
        double[] dArray8 = dArray;
        double[] dArray9 = dArray2;
        double[] dArray10 = dArray3;
        for (int i = n2; i < n3; ++i) {
            dArray10[i] = 0.0;
            dArray9[i] = 0.0;
            dArray8[i] = 0.0;
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        for (n4 = n2; n4 < n3; ++n4) {
            Item item = this.itemSet.get(n4);
            if (!(item instanceof HavingVelocity) || !(item instanceof HavingMass)) continue;
            int n6 = this.itemSet.getPossibleInteractingIndexes(this.interactingIndexes[n], n4);
            d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (int i = 0; i < n6; ++i) {
                int n7 = this.interactingIndexes[n][i];
                if (n7 == n4) continue;
                Item item2 = this.itemSet.get(n7);
                for (InteractionRule interactionRule : this.interactionRules) {
                    if (interactionRule instanceof SymmetricInteractionRule && n7 >= n2 && n7 < n3) {
                        if (n7 >= n4 || !interactionRule.calculateForce(dArray7, item, item2, this.t)) continue;
                        d2 += dArray7[0];
                        d3 += dArray7[1];
                        d4 += dArray7[2];
                        int n8 = n7;
                        dArray8[n8] = dArray8[n8] - dArray7[0];
                        int n9 = n7;
                        dArray9[n9] = dArray9[n9] - dArray7[1];
                        int n10 = n7;
                        dArray10[n10] = dArray10[n10] - dArray7[2];
                        l3 += 2L;
                        l2 += 2L;
                        continue;
                    }
                    if (!interactionRule.calculateForce(dArray7, item, item2, this.t)) continue;
                    d2 += dArray7[0];
                    d3 += dArray7[1];
                    d4 += dArray7[2];
                    ++l2;
                }
            }
            l += n6 < this.n ? (long)this.interactingIndexes[n][n6] : (long)this.n;
            ++n5;
            int n11 = n4;
            dArray8[n11] = dArray8[n11] + d2;
            int n12 = n4;
            dArray9[n12] = dArray9[n12] + d3;
            int n13 = n4;
            dArray10[n13] = dArray10[n13] + d4;
        }
        this.countOfCheckedNeighbours.addAndGet(l);
        this.countOfProcessedInteractions.addAndGet(l2);
        this.countOfProcessedSymmetricInteractions.addAndGet(l3);
        this.countOfProcessedItems.addAndGet(n5);
        n4 = this.getViscousForces() ? 1 : 0;
        double d5 = this.getVelocityLimit() * d;
        d2 = this.getAccelerationLimit() * d;
        for (int i = n2; i < n3; ++i) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            Item item = this.itemSet.get(i);
            if (!(item instanceof HavingVelocity) || !(item instanceof HavingMass)) {
                dArray6[i] = 0.0;
                dArray5[i] = 0.0;
                dArray4[i] = 0.0;
                dArray3[i] = 0.0;
                dArray2[i] = 0.0;
                dArray[i] = 0.0;
                continue;
            }
            HavingVelocity havingVelocity = (HavingVelocity)item;
            double d14 = havingVelocity.getVelocityX();
            double d15 = havingVelocity.getVelocityY();
            double d16 = havingVelocity.getVelocityZ();
            double d17 = 1.0 / ((HavingMass)item).getMass();
            double d18 = dArray8[i];
            double d19 = dArray9[i];
            double d20 = dArray10[i];
            double d21 = d18 * d17;
            double d22 = d19 * d17;
            double d23 = d20 * d17;
            if (n4 != 0) {
                d13 = d21 * d;
                d12 = d22 * d;
                d11 = d23 * d;
                d10 = d21 - d14;
                d9 = d22 - d15;
                d8 = d23 - d16;
            } else {
                d13 = d14 * d;
                d12 = d15 * d;
                d11 = d16 * d;
                d10 = d21 * d;
                d9 = d22 * d;
                d8 = d23 * d;
            }
            if (d2 < Double.POSITIVE_INFINITY) {
                double d24;
                d7 = d10 * d10 + d9 * d9 + d8 * d8;
                if (d24 > d2 * d2) {
                    d6 = d2 / Math.sqrt(d7);
                    d10 *= d6;
                    d9 *= d6;
                    d8 *= d6;
                }
            }
            if (d5 < Double.POSITIVE_INFINITY) {
                double d25;
                d7 = d13 * d13 + d12 * d12 + d11 * d11;
                if (d25 > d5 * d5) {
                    d6 = d5 / Math.sqrt(d7);
                    d13 *= d6;
                    d12 *= d6;
                    d11 *= d6;
                }
            }
            dArray[i] = d13;
            dArray2[i] = d12;
            dArray3[i] = d11;
            dArray4[i] = d10;
            dArray5[i] = d9;
            dArray6[i] = d8;
        }
    }

    protected void preprocess() {
        if (this.itemSet.size() != this.n || this.numberOfParallelTasks != this.interactingIndexes.length) {
            this.n = this.itemSet.size();
            this.interactingIndexes = new int[this.numberOfParallelTasks][this.n];
        }
        this.itemSet.preprocess();
    }
}

