/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import net.algart.model3d.common.movement.model.HavingCenter;
import net.algart.model3d.common.movement.model.HavingInteractionRadius;
import net.algart.model3d.common.movement.model.HavingMass;
import net.algart.model3d.common.movement.model.HavingVelocity;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.Spherical;

public final class ElasticBall
implements Item,
HavingCenter,
Spherical,
HavingInteractionRadius,
HavingMass,
HavingVelocity {
    private static final double SPHERE_VOLUME_COEFFICIENT = 4.1887902047863905;
    private double x;
    private double y;
    private double z;
    private double radius;
    private float density;
    private float elasticityModulus;
    private final float frictionCoefficient;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public ElasticBall(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d4 < 0.0) {
            throw new IllegalArgumentException("Negative radius " + d4);
        }
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.radius = (float)d4;
        this.elasticityModulus = (float)d6;
        this.density = (float)d5;
        this.frictionCoefficient = (float)d7;
    }

    public float getDensity() {
        return this.density;
    }

    public void setDensity(float f) {
        this.density = f;
    }

    public double getElasticityModulus() {
        return this.elasticityModulus;
    }

    public float getFrictionCoefficient() {
        return this.frictionCoefficient;
    }

    public final double getCenterX() {
        return this.x;
    }

    public final double getCenterY() {
        return this.y;
    }

    public final double getCenterZ() {
        return this.z;
    }

    public void setCenterX(double d) {
        this.x = d;
    }

    public void setCenterY(double d) {
        this.y = d;
    }

    public void setCenterZ(double d) {
        this.z = d;
    }

    public void setCenter(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.x) || Double.isInfinite(this.y) || Double.isInfinite(this.z);
    }

    public final double squareOfDistance(HavingCenter havingCenter) {
        double d = havingCenter.getCenterX();
        double d2 = havingCenter.getCenterY();
        double d3 = havingCenter.getCenterZ();
        return (d - this.x) * (d - this.x) + (d2 - this.y) * (d2 - this.y) + (d3 - this.z) * (d3 - this.z);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
    }

    public boolean intersects(Spherical spherical) {
        double d = this.radius + spherical.getRadius();
        return this.squareOfDistance(spherical) < d * d;
    }

    public double getMaxInteractionRadius() {
        return this.radius;
    }

    public double getMass() {
        return 4.1887902047863905 * this.radius * this.radius * this.radius * (double)this.density;
    }

    public double getVelocityX() {
        return this.velocityX;
    }

    public double getVelocityY() {
        return this.velocityY;
    }

    public double getVelocityZ() {
        return this.velocityZ;
    }

    public void setVelocityX(double d) {
        this.velocityX = d;
    }

    public void setVelocityY(double d) {
        this.velocityY = d;
    }

    public void setVelocityZ(double d) {
        this.velocityZ = d;
    }

    public void setVelocity(double d, double d2, double d3) {
        this.velocityX = d;
        this.velocityY = d2;
        this.velocityZ = d3;
    }

    public String toString() {
        return "elastic ball:x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", radius=" + this.radius + ", density=" + this.density + ", elasticityModulus=" + this.elasticityModulus + ", resistanceCoefficient=" + this.frictionCoefficient + ", velocityX=" + this.velocityX + ", velocityY=" + this.velocityY + ", velocityZ=" + this.velocityZ;
    }
}

