/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import net.algart.model3d.common.movement.model.BunkerWall;
import net.algart.model3d.common.movement.model.ElasticBall;
import net.algart.model3d.common.movement.model.InteractionRule;
import net.algart.model3d.common.movement.model.Item;

public final class ElasticBallByBunkerWallInteractionRule
implements InteractionRule {
    public boolean isApplicable(Item item, Item item2) {
        return item instanceof ElasticBall && item2 instanceof BunkerWall;
    }

    public boolean calculateForce(double[] dArray, Item item, Item item2, double d) {
        double d2;
        double d3;
        double d4;
        if (!(item instanceof ElasticBall) || !(item2 instanceof BunkerWall)) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return false;
        }
        ElasticBall elasticBall = (ElasticBall)item;
        BunkerWall bunkerWall = (BunkerWall)item2;
        double d5 = bunkerWall.getA();
        double d6 = bunkerWall.getB();
        double d7 = bunkerWall.getC();
        double d8 = bunkerWall.getD();
        double d9 = d5 * elasticBall.getCenterX() + d6 * elasticBall.getCenterY() + d7 * elasticBall.getCenterZ() - d8;
        if (d9 >= (d4 = elasticBall.getRadius())) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return false;
        }
        double d10 = Math.max(d9, 0.0);
        double d11 = Math.PI * (d4 * d4 - d10 * d10);
        double d12 = elasticBall.getElasticityModulus() * d11 * (d4 - d9) / (2.0 * d4);
        dArray[0] = d12 * d5;
        dArray[1] = d12 * d6;
        dArray[2] = d12 * d7;
        double d13 = (double)elasticBall.getFrictionCoefficient() * d11 * d12;
        double d14 = elasticBall.getVelocityX();
        double d15 = Math.sqrt(d14 * d14 + (d3 = elasticBall.getVelocityY()) * d3 + (d2 = elasticBall.getVelocityZ()) * d2);
        if (d15 != 0.0) {
            double d16 = 1.0 / d15;
            dArray[0] = dArray[0] - d13 * d14 * d16;
            dArray[1] = dArray[1] - d13 * d3 * d16;
            dArray[2] = dArray[2] - d13 * d2 * d16;
        }
        return true;
    }
}

