/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import net.algart.model3d.common.movement.model.ElasticBall;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.SymmetricInteractionRule;

public final class ElasticBallsInteractionRule
implements SymmetricInteractionRule {
    public boolean isApplicable(Item item, Item item2) {
        return item instanceof ElasticBall && item2 instanceof ElasticBall;
    }

    public boolean calculateForce(double[] dArray, Item item, Item item2, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (!(item instanceof ElasticBall) || !(item2 instanceof ElasticBall)) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return false;
        }
        ElasticBall elasticBall = (ElasticBall)item;
        ElasticBall elasticBall2 = (ElasticBall)item2;
        double d6 = elasticBall.getRadius();
        double d7 = elasticBall2.getRadius();
        double d8 = elasticBall.squareOfDistance(elasticBall2);
        double d9 = Math.sqrt(d8);
        if (d9 >= d6 + d7) {
            dArray[2] = 0.0;
            dArray[1] = 0.0;
            dArray[0] = 0.0;
            return false;
        }
        double d10 = d7 <= d6 ? d7 : d6;
        double d11 = d5 = d7 >= d6 ? d7 : d6;
        if (d8 + d10 * d10 >= d5 * d5) {
            d4 = d10 * d10;
        } else {
            d3 = 0.5 * (d6 + d7 + d9);
            d2 = d3 * (d3 - d6) * (d3 - d7) * (d3 - d9);
            d4 = 4.0 * d2 / d8;
        }
        d3 = Math.PI * d4;
        d2 = 0.5 * (elasticBall.getElasticityModulus() + elasticBall2.getElasticityModulus()) * d3 * (d6 + d7 - d9) / (2.0 * (d6 + d7));
        dArray[0] = d2 * (elasticBall.getCenterX() - elasticBall2.getCenterX()) / d9;
        dArray[1] = d2 * (elasticBall.getCenterY() - elasticBall2.getCenterY()) / d9;
        dArray[2] = d2 * (elasticBall.getCenterZ() - elasticBall2.getCenterZ()) / d9;
        double d12 = 0.5 * (double)(elasticBall.getFrictionCoefficient() + elasticBall2.getFrictionCoefficient()) * d3 * d2;
        double d13 = elasticBall.getVelocityX() - elasticBall2.getVelocityX();
        double d14 = elasticBall.getVelocityY() - elasticBall2.getVelocityY();
        double d15 = elasticBall.getVelocityZ() - elasticBall2.getVelocityZ();
        double d16 = Math.sqrt(d13 * d13 + d14 * d14 + d15 * d15);
        if (d16 != 0.0) {
            double d17 = 1.0 / d16;
            dArray[0] = dArray[0] - d12 * d13 * d17;
            dArray[1] = dArray[1] - d12 * d14 * d17;
            dArray[2] = dArray[2] - d12 * d15 * d17;
        }
        return true;
    }
}

