/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.common.movement.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.algart.model3d.common.movement.model.HavingInteractionRadius;
import net.algart.model3d.common.movement.model.Item;
import net.algart.model3d.common.movement.model.ItemListBuilder;
import net.algart.model3d.common.movement.model.ItemSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleItemSet
implements ItemSet {
    final List<Item> items;
    float[] x = new float[0];
    float[] y = new float[0];
    float[] z = new float[0];
    float[] maxR = new float[0];

    public SimpleItemSet(ItemListBuilder itemListBuilder) {
        this.items = itemListBuilder.newItemList();
    }

    public SimpleItemSet() {
        this(ItemListBuilder.DEFAULT);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public Item get(int n) {
        return this.items.get(n);
    }

    @Override
    public void set(int n, Item item) {
        if (item == null) {
            throw new NullPointerException("Null newItem");
        }
        this.items.set(n, item);
    }

    @Override
    public void add(Item item) {
        if (item == null) {
            throw new NullPointerException("Null newItem");
        }
        this.items.add(item);
    }

    @Override
    public List<Item> getAll() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public <T extends Item> List<T> getAll(Class<? extends T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Item item : this.items) {
            if (!clazz.isInstance(item)) continue;
            arrayList.add(clazz.cast(item));
        }
        return arrayList;
    }

    @Override
    public void addAll(Collection<? extends Item> collection) {
        for (Item item : collection) {
            this.add(item);
        }
    }

    @Override
    public void removeItems(int n, int n2) {
        this.items.subList(n, n2).clear();
    }

    @Override
    public int getPossibleInteractingIndexes(int[] nArray, int n) {
        if (nArray == null) {
            throw new NullPointerException("Null result argument");
        }
        double d = this.maxR[n];
        double d2 = this.x[n];
        double d3 = this.y[n];
        double d4 = this.z[n];
        int n2 = 0;
        int n3 = this.items.size();
        for (int i = 0; i < n3; ++i) {
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11 = this.maxR[i];
            double d12 = d + d11;
            if (d12 != Double.POSITIVE_INFINITY && !(d12 * d12 >= d10 * (d9 = (double)this.x[i] - d2) + d8 * (d7 = (double)this.y[i] - d3) + d6 * (d5 = (double)this.z[i] - d4))) continue;
            if (n2 >= nArray.length) {
                throw new IllegalStateException("Not enough memory in result argument (" + nArray.length + ")");
            }
            nArray[n2++] = i;
        }
        if (n2 < nArray.length) {
            nArray[n2] = n3;
        }
        return n2;
    }

    @Override
    public void preprocess() {
        int n = this.size();
        if (n != this.x.length) {
            this.x = new float[n];
            this.y = new float[n];
            this.z = new float[n];
            this.maxR = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            Item item = this.items.get(i);
            if (item instanceof HavingInteractionRadius) {
                HavingInteractionRadius havingInteractionRadius = (HavingInteractionRadius)item;
                this.maxR[i] = (float)havingInteractionRadius.getMaxInteractionRadius();
                this.x[i] = (float)havingInteractionRadius.getCenterX();
                this.y[i] = (float)havingInteractionRadius.getCenterY();
                this.z[i] = (float)havingInteractionRadius.getCenterZ();
                continue;
            }
            this.maxR[i] = Float.POSITIVE_INFINITY;
        }
    }

    public String toString() {
        return "simple set of " + this.size() + " items";
    }
}

